/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.util;

import com.mojang.authlib.GameProfile;
import dev.felnull.otyacraftengine.client.entity.ClientPlayerInfoManager;
import dev.felnull.otyacraftengine.client.entity.PlayerNameByUUIDResult;
import dev.felnull.otyacraftengine.client.entity.PlayerUUIDByNameResult;
import dev.felnull.otyacraftengine.explatform.client.OEClientExpectPlatform;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class OEClientUtils {
    private static final class_310 mc = class_310.method_1551();

    public static float getParSecond(long loopTime) {
        return (float)(System.currentTimeMillis() % loopTime) / (float)loopTime;
    }

    public static class_3675.class_306 getKey(@NotNull class_304 keyMapping) {
        return OEClientExpectPlatform.getKey(keyMapping);
    }

    @NotNull
    public static GameProfile getPlayerLackProfileTolerance(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getLackProfileTolerance(name);
    }

    @NotNull
    public static Optional<UUID> getPlayerUUIDByName(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByName(name);
    }

    @NotNull
    public static CompletableFuture<Optional<UUID>> getPlayerUUIDByNameAsync(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByNameAsync(name);
    }

    @NotNull
    public static Optional<String> getPlayerNameByUUID(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUID(uuid);
    }

    @NotNull
    public static CompletableFuture<Optional<String>> getPlayerNameByUUIDAsync(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUIDAsync(uuid);
    }

    @NotNull
    public PlayerUUIDByNameResult getPlayerUUIDByNameTolerance(@NotNull String name) {
        return ClientPlayerInfoManager.getInstance().getUUIDByNameTolerance(name);
    }

    @NotNull
    public PlayerNameByUUIDResult getPlayerNameByUUIDTolerance(@NotNull UUID uuid) {
        return ClientPlayerInfoManager.getInstance().getNameByUUIDTolerance(uuid);
    }

    public static boolean isKeyInput(int keyCode) {
        if (keyCode < 0) {
            return false;
        }
        long winID = class_310.method_1551().method_22683().method_4490();
        if (keyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)winID, (int)keyCode) == 1;
        }
        return class_3675.method_15987((long)winID, (int)keyCode);
    }

    public static boolean isKeyInput(@NotNull class_304 keyMapping) {
        return OEClientUtils.isKeyInput(OEClientUtils.getKey(keyMapping).method_1444());
    }

    public static double getMouseX() {
        return OEClientUtils.mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
    }

    public static double getMouseY() {
        return OEClientUtils.mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
    }

    @Nullable
    public static File[] openFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects) {
        return OEClientUtils.openFilterFileChooser(title, defaultPath, singleFilter, allowMultipleSelects, new String[0]);
    }

    @Nullable
    public static File[] openFilterFileChooser(@Nullable String title, @Nullable Path defaultPath, @Nullable String singleFilter, boolean allowMultipleSelects, String ... filterPatterns) {
        String ret;
        if (filterPatterns == null || filterPatterns.length == 0) {
            ret = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), null, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer patterns = stack.mallocPointer(filterPatterns.length);
                for (String filterPattern : filterPatterns) {
                    if (filterPattern == null) continue;
                    patterns.put(stack.UTF8((CharSequence)filterPattern));
                }
                patterns.flip();
                ret = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)(defaultPath != null ? defaultPath.toString() : null), (PointerBuffer)patterns, (CharSequence)singleFilter, (boolean)allowMultipleSelects);
            }
        }
        if (ret == null) {
            return null;
        }
        try {
            if (allowMultipleSelects) {
                String[] sp = ret.split("\\|");
                File[] fl = new File[sp.length];
                for (int i = 0; i < sp.length; ++i) {
                    fl[i] = new File(sp[i]);
                }
                return fl;
            }
            return new File[]{new File(ret)};
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getWidthOmitText(String text, float maxWidth, String exit) {
        int wh = OEClientUtils.mc.field_1772.method_1727(text);
        if ((float)wh > maxWidth) {
            int exwh = OEClientUtils.mc.field_1772.method_1727(exit);
            StringBuilder sb = new StringBuilder();
            for (char c : text.toCharArray()) {
                sb.append(c);
                if ((float)OEClientUtils.mc.field_1772.method_1727(sb.toString()) > maxWidth - (float)exwh) break;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(exit);
            return sb.toString();
        }
        return text;
    }
}

